/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.core.economy.storage;

import java.util.Optional;
import net.impactdev.impactor.api.configuration.Config;
import net.impactdev.impactor.api.plugin.ImpactorPlugin;
import net.impactdev.impactor.api.storage.StorageType;
import net.impactdev.impactor.api.storage.connection.configurate.loaders.HoconLoader;
import net.impactdev.impactor.api.storage.connection.configurate.loaders.JsonLoader;
import net.impactdev.impactor.api.storage.connection.configurate.loaders.YamlLoader;
import net.impactdev.impactor.core.economy.EconomyConfig;
import net.impactdev.impactor.core.economy.storage.EconomyStorage;
import net.impactdev.impactor.core.economy.storage.EconomyStorageImplementation;
import net.impactdev.impactor.core.economy.storage.implementations.ConfigurateProvider;
import net.impactdev.impactor.core.economy.storage.implementations.SQLProvider;
import net.impactdev.impactor.core.storage.sql.MariaDbConnectionImpl;
import net.impactdev.impactor.core.storage.sql.MySQLConnectionImpl;
import org.jetbrains.annotations.NotNull;

public final class StorageFactory {
    public static EconomyStorage instance(ImpactorPlugin plugin, @NotNull Config config, @NotNull StorageType fallback) {
        StorageType use = Optional.ofNullable(config.get(EconomyConfig.STORAGE_TYPE)).orElse(fallback);
        plugin.logger().info("Loading storage provider... [" + use.getName() + "]");
        return new EconomyStorage(StorageFactory.createNewImplementation(use, config));
    }

    private static EconomyStorageImplementation createNewImplementation(StorageType type, Config config) {
        return switch (type) {
            case StorageType.JSON -> new ConfigurateProvider(new JsonLoader());
            case StorageType.YAML -> new ConfigurateProvider(new YamlLoader());
            case StorageType.HOCON -> new ConfigurateProvider(new HoconLoader());
            case StorageType.MYSQL -> new SQLProvider(new MySQLConnectionImpl(config.get(EconomyConfig.STORAGE_CREDENTIALS)), config.get(EconomyConfig.SQL_TABLE_PREFIX));
            case StorageType.MARIADB -> new SQLProvider(new MariaDbConnectionImpl(config.get(EconomyConfig.STORAGE_CREDENTIALS)), config.get(EconomyConfig.SQL_TABLE_PREFIX));
            default -> throw new IllegalArgumentException("Unsupported storage type: " + String.valueOf((Object)type));
        };
    }
}

